#ifndef __ROUTINE_COMPOSITE_H__
#define __ROUTINE_COMPOSITE_H__

#include "global.h"
#include "routine.h"

#define OPT_ADD 1    	/* addition */
#define OPT_SUB 2	/* subtraction */
#define OPT_MUL 3	/* multiplication */
#define OPT_DIV 4	/* division */
#define OPT_AND 5	/* logical and */
#define OPT_OR  6	/* logical or */
#define OPT_NOT 7	/* logical not */
#define OPT_NOP 8	/* no operation */
#define OPT_IF  9	/* branch (3 parameters) */
#define OPT_GT 10	/* greater than */
#define OPT_LT 11	/* less than */
#define OPT_GE 12	/* greater or equal */
#define OPT_LE 13	/* less or equal */
#define OPT_UN 14	/* union of sets */
#define OPT_IN 15	/* intersection of sets */
#define OPT_CI 16	/* value is an integer or boolean  constant */
#define OPT_EM 17	/* is the set empty ? */
#define OPT_AT 18	/* value is the index of the attribute to query */
#define OPT_FN 19	/* value is the index of the routine to query */
#define OPT_EQL 20	/* equality */

typedef struct S_OPT {
	int type;
	u64 value;
	struct S_OPT *param1;
	struct S_OPT *param2;
	struct S_OPT *param3;
	} OPT;

void dump_operation(FILE *fout, OPT *o);
int evalute_operation(OPT *o,u64 *result);
int execute_composite(ROUTINE *r,u64 *param,void *data, u64 *result);

#endif
